@extends('admin.layouts.main')
@section('container')
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- jquery validation -->
            @if (session()->has('error'))
                <div class="alert alert-danger text-center">
                    {{ session()->get('error') }}
                </div>
            @endif
            @if (session()->has('success'))
                <div class="alert alert-success text-center">
                    {{ session()->get('success') }}
                </div>
            @endif
            <div class="card card-warning">
                <div class="card-header">
                    <h3 class="card-title">แก้ไขข้อมูลข่าวสาร</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form action="{{ route('profiles.update',''.$data->id.'') }}" method="post">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="form-group">
                            <label for="exampleInputEmail1">เนื้อหา <small class="text-danger">*</small></label>
                            <textarea class="form-control" name="profiles_name" id="profiles_name" cols="30"
                                rows="10">{{ $data->profiles_name }}</textarea>
                            <small class="text-danger">{{ $errors->first('profiles_name') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">ออฟชันก์ <small class="text-danger">*</small></label>
                            <select name="profiles_status" class="form-control" id="profiles_status">
                                <option value="0" {{$data->profiles_status == 0 ? 'selected':''}}>ยังไม่เปิดใช้</option>
                                <option value="1" {{$data->profiles_status == 1 ? 'selected':''}}>เปิดใช้ในทันที</option>
                            </select>
                        </div>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer text-center">
                        <a href="{{ asset('admin/profiles') }}"><button type="button"
                            class="btn btn-danger">ยกเลิก</button></a>
                        <button type="submit" class="btn btn-warning">แก้ไขข้อมูล</button>
                    </div>
                </form>
            </div>
            <!-- /.card -->
        </div>
        <!--/.col (left) -->

    </div>
@endsection
@section('scriptadd')
    <script>
        $('document').ready(function() {
            $("#files").change(function() {
                if (this.files && this.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $("#imgshow").html('<img src="' + e.target.result + '" align="left">')
                    }
                    reader.readAsDataURL(this.files[0]);
                }
            });
        });
    </script>
@endsection
