@extends('admin.layouts.main')
@section('container')
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- jquery validation -->
            @if (session()->has('error'))
                <div class="alert alert-danger text-center">
                    {{ session()->get('error') }}
                </div>
            @endif
            @if (session()->has('success'))
                <div class="alert alert-success text-center">
                    {{ session()->get('success') }}
                </div>
            @endif
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">เพิ่มข้อมูลสไลด์</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form action="{{ route('slide.store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        <div class="form-group">
                            <label for="exampleInputEmail1">รูปภาพ <small class="text-danger">*</small></label>
                            <input class="form-control" type="file" id="files" name="files">
                            <small class="text-danger">{{ $errors->first('files') }}</small>
                            <span id="imgshow"></span>
                        </div>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer text-center">
                        <button type="submit" class="btn btn-success">เพิ่มข้อมูล</button>
                    </div>
                </form>
            </div>
            <!-- /.card -->
        </div>
        <!--/.col (left) -->

    </div>
@endsection
@section('scriptadd')    
<script>
    $('document').ready(function() {
        $("#files").change(function() {
            if (this.files && this.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $("#imgshow").html('<img src="'+e.target.result+'" align="left" class="img-fluid">')
                }
                reader.readAsDataURL(this.files[0]);
            }
        });
    });
</script>
@endsection
