@inject('menu', 'App\Models\Other\Other')
@extends('admin.layouts.main')
@section('container')
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- jquery validation -->
            @if (session()->has('error'))
                <div class="alert alert-danger text-center">
                    {{ session()->get('error') }}
                </div>
            @endif
            @if (session()->has('success'))
                <div class="alert alert-success text-center">
                    {{ session()->get('success') }}
                </div>
            @endif
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">เพิ่มข้อมูลสินค้า</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form action="{{ route('products.store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        <div class="form-group">
                            <label for="exampleInputEmail1">ชื่อสินค้า <small class="text-danger">*</small></label>
                            <input type="text" name="products_name" class="form-control" id="products_name"
                                placeholder="ชื่อสินค้า" value="{{ old('products_name') }}">
                            <small class="text-danger">{{ $errors->first('products_name') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">ราคา <small class="text-danger">*</small></label>
                            <input type="number" name="products_price" class="form-control" id="products_price"
                                placeholder="ราคา" value="{{ old('products_price') }}" step="any">
                            <small class="text-danger">{{ $errors->first('products_price') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">หมวดหมู่ <small class="text-danger">*</small></label>
                            @php
                                $datamenu = $menu->productmenu();
                            @endphp
                            <select name="products_categorys" id="products_categorys" class="form-control">
                                @foreach ($datamenu as $rows)
                                    <option value="{{ $rows->id }}">{{ $rows->categorys_names }}</option>
                                @endforeach
                            </select>
                            <small class="text-danger">{{ $errors->first('products_categorys') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">คุณลักษณะ <small class="text-danger">*</small></label>
                            <input type="text" name="products_attribute" class="form-control" id="products_attribute"
                                placeholder="คุณลักษณะ" value="{{ old('products_attribute') }}">
                            <small class="text-danger">{{ $errors->first('products_attribute') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">คุณสมบัติ <small class="text-danger">*</small></label>
                            <input type="text" name="products_detail" class="form-control" id="products_detail"
                                placeholder="คุณสมบัติ" value="{{ old('products_detail') }}">
                            <small class="text-danger">{{ $errors->first('products_detail') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">การใช้งาน <small class="text-danger">*</small></label>
                            <input type="text" name="products_usability" class="form-control" id="products_usability"
                                placeholder="การใช้งาน" value="{{ old('products_usability') }}">
                            <small class="text-danger">{{ $errors->first('products_usability') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">ข้อควรระวัง <small class="text-danger">*</small></label>
                            <input type="text" name="products_warning" class="form-control" id="products_warning"
                                placeholder="ข้อควรระวัง" value="{{ old('products_warning') }}">
                            <small class="text-danger">{{ $errors->first('products_warning') }}</small>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">รูปภาพโชว์สินค้า <small class="text-danger">*</small></label>
                            <input class="form-control" type="file" id="files" name="files" onchange="previewFile()">
                            <small class="text-danger">{{ $errors->first('files') }}</small>
                            <span id="imgshow"></span>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">รูปภาพสินค้าทั้งหมด <span
                                    class="text-danger">(**สามารถอัพได้หลายไฟล์ กด Shift ค้างไว้ตอนเลือกรูปภาพ**)</span>
                                <small class="text-danger">*</small></label>
                            <input class="form-control" type="file" id="files_multi" name="files_multi[]"
                                onchange="previewFilesmulti()" multiple>
                            <small class="text-danger">{{ $errors->first('files_multi') }}</small>
                            <br />
                            <span id="imgshowmulti"></span>
                        </div>
                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer text-center">
                        <a href="{{ asset('admin/products') }}"><button type="button"
                                class="btn btn-danger">ยกเลิก</button></a>
                        <button type="submit" class="btn btn-success">เพิ่มข้อมูล</button>
                    </div>

                </form>
            </div>
            <!-- /.card -->
        </div>
        <!--/.col (left) -->

    </div>
@endsection
@section('scriptadd')
    <script>
        function previewFile() {
            $("#imgshow").empty();
            const preview = document.querySelector('#imgshow');
            const file = document.querySelector('input[id=files]').files[0];
            const reader = new FileReader();

            reader.addEventListener("load", function() {
                var image = new Image();
                image.height = 300;
                image.title = file.name;
                image.src = this.result;
                preview.appendChild(image);
            }, false);

            if (file) {
                reader.readAsDataURL(file);
            }
        }

        function previewFilesmulti() {
            $("#imgshowmulti").empty();
            var preview = document.querySelector('#imgshowmulti');
            var files = document.querySelector('input[id=files_multi]').files;

            function readAndPreview(file) {
                // Make sure `file.name` matches our extensions criteria
                if (/\.(jpe?g|png|gif)$/i.test(file.name)) {
                    var reader = new FileReader();
                    reader.addEventListener("load", function() {
                        var image = new Image();
                        image.height = 300;
                        image.title = file.name;
                        image.src = this.result;
                        preview.appendChild(image);
                    }, false);

                    reader.readAsDataURL(file);
                }

            }

            if (files) {
                [].forEach.call(files, readAndPreview);
            }

        }
    </script>
@endsection
