<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Product\Product;
use App\Http\Requests\ProductsRequest;

class ProductController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $data = Product::all();
        return view('admin.data.products.products', compact('data'));
    }

    public function form()
    {
        return view('admin.form.products.products');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ProductsRequest $request)
    {
        //
        if ($request->hasFile('files') && session('username') && $request->hasFile('files_multi')) {
            $file = $request->file('files');
            $files_multi = $request->file('files_multi');
            $path = "img_product";
            $sum_multi = [];
            
            if(count($files_multi)){
                foreach ($files_multi as $key => $value) {  
                    if ($value->getClientMimeType() == 'image/png' || $value->getClientMimeType() == 'image/jpeg') {                
                        $value->move($path, $value->getClientOriginalName());
                        $sum_multi[] = ["id" => $key, "path" =>$path."/".$value->getClientOriginalName()];
                    } else {
                        unlink($sum_multi);
                        return back()->with('error', 'กรุณาใส่ไฟล์ที่กำหนดไว้เท่านั้น');
                    }                                      
                }
            }else{
                return back()->with('error', 'เพิ่มข้อมูลไม่สำเร็จ');
            }

            
            if ($file->getClientMimeType() == 'image/png' || $file->getClientMimeType() == 'image/jpeg') {                
                $path = $file->move($path, $file->getClientOriginalName());
            } else {
                return back()->with('error', 'กรุณาใส่ไฟล์ที่กำหนดไว้เท่านั้น');
            }
          
            $data = Product::create(
                [
                    'products_img' => $path,
                    'products_img_multi' => json_encode($sum_multi,JSON_UNESCAPED_UNICODE),
                    'products_name' => $request->products_name,
                    'products_price' => $request->products_price,
                    'products_categorys' => $request->products_categorys,
                    'products_attribute' => $request->products_attribute,
                    'products_detail' => $request->products_detail,
                    'products_usability' => $request->products_usability,
                    'products_warning' => $request->products_warning,
                    'products_pics' => $request->products_pics
                ]
            );
            if ($data) {
                return redirect('/admin/products')->with('success', 'เพิ่มข้อมูลสำเร็จ');
            } else {
                return back()->with('error', 'เพิ่มข้อมูลไม่สำเร็จ');
            }            
        } else {
            return back()->with('error', 'อัพโหลดไม่สำเร็จ');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $data = Product::find($id);

        return view('admin.form_edit.products.products', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ProductsRequest $request, $id)
    {
        //
        $path = "img_product";
        if ($request->hasFile('files') && session('username')) {
            $file = $request->file('files');
            if ($file->getClientMimeType() == 'image/png' || $file->getClientMimeType() == 'image/jpeg') {
                $path = $file->move($path, $file->getClientOriginalName());
                $data = Product::where('id', $id)->update([
                    'products_img' => $path,
                    'products_name' => $request->products_name,
                    'products_price' => $request->products_price,
                    'products_categorys' => $request->products_categorys,
                    'products_attribute' => $request->products_attribute,
                    'products_usability' => $request->products_usability,
                    'products_warning' => $request->products_warning,
                    'products_detail' => $request->products_detail
                ]);
                if ($data) {
                    return redirect('/admin/products')->with('success', 'แก้ไขข้อมูลสำเร็จ');
                } else {
                    return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
                }
            } else {
                return back()->with('error', 'กรุณาใส่ไฟล์ที่กำหนดไว้เท่านั้น');
            }
        }
        if ($request->hasFile('files_multi') && session('username')) {
            $files_multi = $request->file('files_multi');
            $sum_multi = [];
            
            if(count($files_multi)){
                foreach ($files_multi as $key => $value) {  
                    if ($value->getClientMimeType() == 'image/png' || $value->getClientMimeType() == 'image/jpeg') {                
                        $value->move($path, $value->getClientOriginalName());
                        $sum_multi[] = ["id" => $key, "path" =>$path."/".$value->getClientOriginalName()];
                    } else {
                        unlink($sum_multi);
                        return back()->with('error', 'กรุณาใส่ไฟล์ที่กำหนดไว้เท่านั้น');
                    }                                      
                }

                $data = Product::where('id', $id)->update([
                    'products_img_multi' => $sum_multi,
                    'products_name' => $request->products_name,
                    'products_price' => $request->products_price,
                    'products_categorys' => $request->products_categorys,
                    'products_attribute' => $request->products_attribute,
                    'products_usability' => $request->products_usability,
                    'products_warning' => $request->products_warning,
                    'products_detail' => $request->products_detail
                ]);
                if ($data) {
                    return redirect('/admin/products')->with('success', 'แก้ไขข้อมูลสำเร็จ');
                } else {
                    return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
                }

            }else{
                return back()->with('error', 'เพิ่มข้อมูลไม่สำเร็จ');
            }

        } else if (!$request->hasFile('files') && !$request->hasFile('files_multi')) {
            $data = Product::where('id', $id)->update([
                'products_name' => $request->products_name,
                'products_price' => $request->products_price,
                'products_attribute' => $request->products_attribute,
                'products_categorys' => $request->products_categorys,
                'products_usability' => $request->products_usability,
                'products_warning' => $request->products_warning,
                'products_detail' => $request->products_detail
            ]);
            if ($data) {
                return redirect('/admin/products')->with('success', 'แก้ไขข้อมูลสำเร็จ');
            } else {
                return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
            }
        } else {
            return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $data = Product::where('id', $id)->delete($id);
        if ($data) {
            return redirect('admin/products')->with('success', 'ลบข้อมูลสำเร็จ');
        } else {
            return back()->with('error', 'ลบข้อมูลไม่สำเร็จ');
        }
    }
}
