<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\News\News;
use App\Http\Requests\NewsRequest;

class NewsController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $data = News::all();
        return view('admin.data.news.news', compact('data'));
    }

    public function form()
    {
        return view('admin.form.news.news');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(NewsRequest $request)
    {
        //
        if ($request->hasFile('files') && session('username')) {
            $file = $request->file('files');
            if ($file->getClientMimeType() == 'image/png' || $file->getClientMimeType() == 'image/jpeg') {
                $path = "img_news";
                $path = $file->move($path, $file->getClientOriginalName());
                $data = News::create(
                    [
                        'news_img' => $path,
                        'news_bodys' => $request->news_bodys,
                        'news_toppics' => $request->news_toppics
                    ]
                );
                if ($data) {
                    return redirect('/admin/news')->with('success', 'เพิ่มข้อมูลสำเร็จ');
                } else {
                    return back()->with('error', 'เพิ่มข้อมูลไม่สำเร็จ');
                }
            } else {
                return back()->with('error', 'กรุณาใส่ไฟล์ที่กำหนดไว้เท่านั้น');
            }
        } else {
            return back()->with('error', 'อัพโหลดไม่สำเร็จ');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $data = News::find($id);

        return view('admin.form_edit.news.news', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(NewsRequest $request, $id)
    {
        //
        if ($request->hasFile('files') && session('username')) {
            $file = $request->file('files');
            if ($file->getClientMimeType() == 'image/png' || $file->getClientMimeType() == 'image/jpeg') {
                $path = "img_news";
                $path = $file->move($path, $file->getClientOriginalName());
                $data = News::where('id', $id)->update([
                    'news_img' => $path,
                    'news_bodys' => $request->news_bodys,
                    'news_toppics' => $request->news_toppics
                ]);
                if ($data) {
                    return redirect('/admin/news')->with('success', 'แก้ไขข้อมูลสำเร็จ');
                } else {
                    return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
                }
            } else {
                return back()->with('error', 'กรุณาใส่ไฟล์ที่กำหนดไว้เท่านั้น');
            }
        } else if (!$request->hasFile('files')) {
            $data = News::where('id', $id)->update([
                'news_bodys' => $request->news_bodys,
                'news_toppics' => $request->news_toppics
            ]);
            if ($data) {
                return redirect('/admin/news')->with('success', 'แก้ไขข้อมูลสำเร็จ');
            } else {
                return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
            }
        } else {
            return back()->with('error', 'แก้ไขข้อมูลไม่สำเร็จ');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $data = News::where('id', $id)->delete($id);
        if ($data) {
            return redirect('admin/news')->with('success', 'ลบข้อมูลสำเร็จ');
        } else {
            return back()->with('error', 'ลบข้อมูลไม่สำเร็จ');
        }
    }
}
